VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "DistributionPlotClass"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder6" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

Public Enum DistributionPlotType
  dptClass
  dptTargetStrength
End Enum

Public Enum DistributionPlotAction
  dpaOptions
  dpaUnknown
  dpaChangeType
  dpaSpace1
End Enum

Private Enum MouseEventType
  MouseUp
  MouseDown
  MouseMove
  Cancel
End Enum

Private Const ANSI_CHARSET = 0
Private Const CLIP_CHARACTER_PRECIS = 1
Private Const FW_NORMAL = 400
Private Const FF_DONT_CARE = 0
Private Const FF_ROMAN = 16      '  Variable stroke width, serifed.
Private Const OUT_DEFAULT_PRECIS = 0
Private Const OUT_DEVICE_PRECIS = 5
Private Const PROOF_QUALITY = 2
Private Const VARIABLE_PITCH = 2

Private Declare Function CreateFont Lib "GDI32" Alias "CreateFontA" _
  (ByVal H As Long, ByVal W As Long, ByVal E As Long, ByVal O As Long, _
   ByVal W As Long, ByVal i As Long, ByVal u As Long, ByVal s As Long, _
   ByVal C As Long, ByVal OP As Long, ByVal CP As Long, ByVal Q As Long, _
   ByVal PAF As Long, ByVal f As String) As Long

Private Declare Function SelectObject Lib "GDI32" _
  (ByVal hDC As Long, ByVal hObject As Long) As Long

Private mAxisColor As Long
Private mBarPaneX0 As Long
Private mBarPaneX1 As Long
Private mBarPaneY0 As Long
Private mBarPaneY1 As Long
Private mBarSeparation As Long
Private mBarWidth As Long
Private mCategoryLabels() As String
Private mClassifier As ClassifierClass
Private mColor() As Long
Private mColormap As ColorMapClass
Private mCounts() As Long
Private mFocusColor As Long
Private mFont As Long
Private mGrandTotal As Long
Private mHaveFocus As Boolean
Private mMenu As Scripting.Dictionary
Private mNBins As Integer
Private mPercentTick As Integer
Private mPercentLabelGap As Integer
Private WithEvents mPicture As PictureBox
Attribute mPicture.VB_VarHelpID = -1
Private mPlotType As DistributionPlotType
Private mPrefix As String
Private mRangeMax As Single
Private mRangeMin As Single
Private mShowCategoryAxis As Boolean
Private mShowPercentAxis As Boolean
Private mShowTopArea As Boolean
Private mTimesliceCount As Integer
Private mTimesliceCurrent As Integer
Private mTimesliceFirst As Integer
Private mTimesliceMax As Integer
Private mTimes() As Date
Private mTotals() As Long
Private mTSMax As Single
Private mTSMin As Single

Public Event ContextMenuRequest(ByVal X As Long, ByVal Y As Long)
Public Event KeyDown(KeyCode As Integer, Shift As Integer)
Public Event StatusBar(ByVal statusText As String)
Public Event DimensionChange()

Private Sub AddMenuItem(ByVal caption As String, _
                        ByVal tag As Integer, _
                        Optional ByVal checked As Boolean = False, _
                        Optional ByVal enabled As Boolean = True, _
                        Optional ByVal visible As Boolean = True)
                        
  Dim item As Scripting.Dictionary
  Set item = New Scripting.Dictionary
  item.Add "caption", caption
  item.Add "tag", tag
  item.Add "checked", checked
  item.Add "enabled", enabled
  item.Add "visible", visible
  mMenu.Add CStr(tag), item
                        
End Sub
Private Sub CategoryAxisLayout()

  Dim i As Integer
  Dim mapName As String
  Dim X As Single
  Dim dx As Single
  
  If Not mColormap Is Nothing Then
  
    If mPlotType = dptClass Then
        
        If mClassifier Is Nothing Then Exit Sub
        For i = 0 To mNBins - 1
            mCategoryLabels(i) = mClassifier.GetClassName(i)
            mColor(i) = mColormap.GetColor(i + mClassifier.GetNImplicitClasses() - 1)
        Next i
        
    Else
    
        X = mTSMin
        dx = (mTSMax - mTSMin) / (mNBins - 2)
        
        'mCategoryLabels(0) = Format(((-80 + mTSMin) / 2), "###.0")
        mCategoryLabels(0) = "[" & Format(-80, "###") & ";" & Format(mTSMin, "###") & "]"
        If Not mColormap Is Nothing Then
            mColor(0) = mColormap.Colorize((-80 + mTSMin) / 2)
        Else
            mColor(0) = vbBlue
        End If
  
        For i = 1 To mNBins - 2
            mCategoryLabels(i) = Format((X + dx / 2), "###.0")
            mColor(i) = mColormap.Colorize(X + dx / 2)
            X = X + dx
        Next i
        
        'mCategoryLabels(mNBins - 1) = Format(((20 + mTSMax) / 2), "###.0")
        mCategoryLabels(mNBins - 1) = "[" & Format(mTSMax, "###") & ";" & Format(20, "###") & "]"
        If Not mColormap Is Nothing Then
            mColor(mNBins - 1) = mColormap.Colorize((20 + mTSMax) / 2)
        Else
            mColor(mNBins - 1) = vbBlue
        End If
        
    End If
    
  Else
            
    If mPlotType = dptClass Then
    
        '  Layout for class type categories
        '
        '  Find the colormap, if possible
    
    
        If mClassifier Is Nothing Then Exit Sub
        mapName = mClassifier.GetColorMapName
        If mapName <> "" Then
         Set mColormap = New ColorMapClass
        mColormap.ReadFromDB mapName
        End If
    
        ' Get the class name and class color.
        ' Trim class name to 12 characters.
        ' Default color is blue
    
        For i = 0 To mNBins - 1
          mCategoryLabels(i) = mClassifier.GetClassName(i)
          If Not mColormap Is Nothing Then
            mColor(i) = mColormap.GetColor(i + mClassifier.GetNImplicitClasses() - 1)
          Else
            mColor(i) = vbBlue
          End If
        Next i
    
    Else
  
        mapName = general.propertyList.GetProperty(mPrefix & ":ColorMapName", "_StandardEnergy")
        If mapName <> "" Then
            Set mColormap = New ColorMapClass
            mColormap.ReadFromDB mapName
        End If
      
        '  Layout for energy type plots
  
        X = mTSMin
        'dx = (mTSMax - mTSMin) / (mNBins - 1)
        'dx = (mTSMax - mTSMin) / mNBins  ' AK Oct_15_2001
        dx = (mTSMax - mTSMin) / (mNBins - 2)  ' AK Nov_2_2001
        
        'mCategoryLabels(0) = Format(((-80 + mTSMin) / 2), "###.0")
        
        mCategoryLabels(0) = "[" & Format(-80, "###") & ";" & Format(mTSMin, "###") & "]"
       
        If Not mColormap Is Nothing Then
            mColor(0) = mColormap.Colorize((-80 + mTSMin) / 2)
        Else
            mColor(0) = vbBlue
        End If
        
        For i = 1 To mNBins - 2
            mCategoryLabels(i) = Format((X + dx / 2), "###.0")
            If Not mColormap Is Nothing Then
                mColor(i) = mColormap.Colorize(X + dx / 2)
            Else
                mColor(i) = vbBlue
            End If
            X = X + dx
        Next i
        
        'mCategoryLabels(mNBins - 1) = Format(((20 + mTSMax) / 2), "###.0")
        
        mCategoryLabels(mNBins - 1) = "[" & Format(mTSMax, "###") & ";" & Format(20, "###") & "]"
       
        If Not mColormap Is Nothing Then
            mColor(mNBins - 1) = mColormap.Colorize((20 + mTSMax) / 2)
        Else
            mColor(mNBins - 1) = vbBlue
        End If
        
    End If

  End If

End Sub
Private Sub CategoryAxisPaint()
                        
  Dim oldfont As Long
  
  '  Erase the axis area
  
  mPicture.Line (mBarPaneX0, mBarPaneY1 + 1)-(mPicture.width, mPicture.height), _
                mPicture.backcolor, BF
  
  oldfont = SelectObject(mPicture.hDC, mFont)
                        
  Dim X As Long
  Dim Y As Long
  X = mBarPaneX0 + mBarSeparation / 2 + mBarWidth / 2
  Y = mBarPaneY1 + 2
  
  Dim i As Integer
  
  If mNBins <= 10 Then
  
    For i = 0 To mNBins - 1
    
        mPicture.CurrentX = X '+ 0.25 * mPicture.TextHeight(mCategoryLabels(i))
        mPicture.CurrentY = Y - 0.87 * 0.5 * mPicture.TextHeight(mCategoryLabels(i))
        mPicture.Print mCategoryLabels(i)
        X = X + mBarSeparation + mBarWidth
  
    Next i

  Else
  
    For i = 0 To mNBins - 1 Step 2
    
        mPicture.CurrentX = X '+ 0.25 * mPicture.TextHeight(mCategoryLabels(i))
        mPicture.CurrentY = Y - 0.87 * 0.5 * mPicture.TextHeight(mCategoryLabels(i))
        mPicture.Print mCategoryLabels(i)
        X = X + 2 * (mBarSeparation + mBarWidth)
  
    Next i
    
  End If
  
  
  SelectObject mPicture.hDC, oldfont
                        
End Sub

Private Sub changeType()

  Dim text As String
  text = "Distribution plot is currently displaying "
  text = text & IIf(mPlotType = dptClass, "classes", "energy") & "."
  text = text & vbCrLf & vbCrLf & "Change plot so it displays "
  text = text & IIf(mPlotType = dptClass, "energy", "classes") & "?"
  
  Dim reply As Integer
  reply = MsgBox(text, vbYesNo + vbQuestion, "Change Distribution Plot Type")
  If reply = vbYes Then
    Me.PlotSetup mPrefix, mPicture, _
      IIf(mPlotType = dptClass, dptTargetStrength, dptClass), mRangeMin, _
      mRangeMax, mTimesliceMax, mNBins, mTSMin, mTSMax
    If mPlotType = dptClass Then
      mMenu.item(CStr(dpaOptions)).item("enabled") = False
    Else
      mMenu.item(CStr(dpaOptions)).item("enabled") = True
    End If
  End If
  
  RaiseEvent DimensionChange

End Sub

Public Sub FormatDPlot()

    Dim changed As Boolean
    
    changed = frmDistributionPlotFormat.GetResults(mTSMin, mTSMax, mNBins)

    If changed Then
        Me.PlotSetup mPrefix, mPicture, _
          IIf(mPlotType = dptClass, dptClass, dptTargetStrength), mRangeMin, _
          mRangeMax, mTimesliceMax, mNBins, mTSMin, mTSMax
    End If
    
    RaiseEvent DimensionChange
              
End Sub

Public Sub Clear()
  
  Dim i As Integer
  Dim j As Integer
  
  For i = 0 To mNBins - 1
  
    mTotals(i) = 0

    For j = 0 To mTimesliceMax - 1
      mCounts(i, j) = 0
    Next j
  
  Next i
  
  mGrandTotal = 0
  
  mTimesliceCount = 0
  mTimesliceCurrent = 0
  mTimesliceFirst = 1
  
  PlotPaint

End Sub
Public Function GetMenu() As Scripting.Dictionary

  Set GetMenu = mMenu

End Function
Private Sub InsertEchoes()
    
  Dim echo As EchoClass
  
  nEchoes = general.sonarIF.GetNEchoes()
  
  Dim i As Integer
  For i = 0 To mNBins - 1
    mCounts(i, mTimesliceCurrent) = 0   ' zero out the counts
  Next i
  
  '  Process each of the ping's echoes
  
  Dim tsBinWidth As Single
  'tsBinWidth = (mTSMax - mTSMin) / (mNBins - 1)
  'tsBinWidth = (mTSMax - mTSMin) / mNBins   'AK Oct_15_2001
  
  ' Based on decision made during code review meeting Nov 2 2001
  ' first and last bins will include all "leftover" echoes
  tsBinWidth = (mTSMax - mTSMin) / (mNBins - 2)
  
  Dim theBin As Integer
  Dim ts As Single
  For i = 0 To nEchoes - 1
    Set echo = general.sonarIF.GetEcho(i)
    If echo.GetRange() >= mRangeMin And echo.GetRange() <= mRangeMax Then
    
      '  For echoes in the range window, determine the appropriate bin number
    
      If mPlotType = dptClass Then
        theBin = echo.GetClassification() ' class determines the bin
      Else
      
        ' Calculate the appropriate bin
      
      
        ' theBin = mNBins - 1   AK Oct_15_2001
         theBin = mNBins - 1    'AK Nov 2 2001
        
        ts = echo.GetTargetStrength()
        Dim j As Integer
        
        ' The commented code below is not entirely correct
        ' Echoes out of specified TS range are still included into
        ' first or last bins. Following is fixed code     AK Oct_15_2001
        
        For j = 0 To mNBins - 2
         If ts <= mTSMin + tsBinWidth * j Then
            theBin = j
            Exit For
         End If
        Next j
        
        'theBin = -1   AK Nov 2 2001
        
        'For j = 0 To mNBins - 1
        'If ts <= mTSMin + tsBinWidth * (j + 1) And _
        '    ts >= mTSMin + tsBinWidth * j Then
        '    theBin = j
        '    Exit For
        ' End If
        'Next j
                
      End If

      '  Add one to the appropriate bin
      'If mPlotType = dptClass Then
        If theBin >= 0 Then   ' Filters out "bottom" in class plots
            mCounts(theBin, mTimesliceCurrent) = mCounts(theBin, mTimesliceCurrent) + 1
        End If
      'Else
      '  If theBin > -1 Then
      '      mCounts(theBin, mTimesliceCurrent) = mCounts(theBin, mTimesliceCurrent) + 1
      ' End If
      'End If
      
    End If
  Next i

End Sub
Public Sub MenuAction(ByVal action As DistributionPlotAction)

  '  Called by a menu handling object (probably a form) to effect
  '  the action requested by the menu.

  Select Case action
  
    Case dpaChangeType
      changeType
      
    Case dpaOptions
      FormatDPlot
      
    Case Else
      Debug.Assert False
      
  End Select

End Sub
Private Sub MouseController(ByVal theEvent As MouseEventType, _
                            ByVal Button As Integer, _
                            ByVal Shift As Integer, _
                            ByVal X As Single, _
                            ByVal Y As Single)
                            
  Dim raiseIt As Boolean
  
  ''''mPicture.SetFocus     ' Grab focus when mouse is over us
                            
  Select Case theEvent
  
    Case MouseUp
      If (Button And vbRightButton) <> 0 Then
         RaiseEvent ContextMenuRequest(X, Y)
      End If


    Case MouseMove
      raiseIt = False
      Dim result As String
      Dim xp As Single
      If X >= mBarPaneX0 And X <= mBarPaneX1 And _
         Y >= mBarPaneY0 And Y <= mBarPaneY1 Then
        xp = X - mBarSeparation / 2
        xp = xp / (mBarWidth + mBarSeparation)
        If mPicture.Point(X, Y) = mPicture.backcolor Then
          raiseIt = False
        Else
          If mGrandTotal <> 0 Then
            result = mCategoryLabels(Fix(xp)) & ": " & mTotals(Fix(xp)) & _
                     Format(mTotals(Fix(xp)) / mGrandTotal * 100, "(##0") & "%)"
          Else
            result = mCategoryLabels(Fix(xp)) & ": 0 (0%)"
          End If
          raiseIt = True
        End If
      Else
        raiseIt = False
      End If
      If Not raiseIt Then
        result = "Distribution Plot::" & _
                 IIf(mPlotType = dptClass, "class", "energy")
      Else
        RaiseEvent StatusBar(result)
      End If
      mPicture.ToolTipText = result
  End Select
                            
End Sub
Private Sub PercentAxisPaint()

  '  Erase the axis area

  mPicture.Line (mBarPaneX1 + 1, mBarPaneY0)-(mPicture.width, mBarPaneY1), _
                mPicture.backcolor, BF
                
  mPicture.CurrentX = mBarPaneX1 + mPercentLabelGap
  mPicture.CurrentY = mBarPaneY0
  mPicture.Print " %"

  Dim i As Integer
  Dim Y As Long
  
  For i = 90 To 10 Step -10
  
    '  Draw in a grid
    
    Y = (1 - (i / 100)) * (mBarPaneY1 - mBarPaneY0) + mBarPaneY0
    
    mPicture.DrawStyle = vbDot
    mPicture.Line (mBarPaneX0, Y)-(mBarPaneX1, Y), mAxisColor
    mPicture.DrawStyle = vbSolid
    
    '  Write in a label
    
    If i Mod 20 = 0 Then
    
      mPicture.Line (mBarPaneX1 + 1, Y)-Step(mPercentTick, 0), mAxisColor
      mPicture.CurrentX = mPicture.CurrentX + mPercentLabelGap
      mPicture.CurrentY = mPicture.CurrentY - mPicture.TextHeight(CStr(i)) / 2
      mPicture.Print CStr(i)
      
    End If
  
  Next i

End Sub
Public Sub PingArrived(ByVal pingNumber As Long)

  If mPlotType = dptClass Then
  
    ' For class type plots, check to see if the classifier has changed.
    ' If it has, resize the arrays.
  
    If mClassifier Is Nothing And general.sonarIF.GetClassifier Is Nothing Then
      Exit Sub ' No classifier, so cannot do much of anything.
    ElseIf Not mClassifier Is general.sonarIF.GetClassifier Then
    
      Set mClassifier = general.sonarIF.GetClassifier
      resizeArrays mClassifier.GetNClasses() - mClassifier.GetNImplicitClasses() + 1 ' for unknown
      PlotLayout
    End If
  
  End If

  mTimesliceCount = mTimesliceCount + 1
  If mTimesliceCount > mTimesliceMax Then
  
    '  All the available time slices are used, so
    '  throw out the oldest one: deduct it from the totals and
    '  adjust the pointers
  
    Dim i As Integer
    For i = 0 To mNBins - 1
      mTotals(i) = mTotals(i) - mCounts(i, mTimesliceFirst)
      mGrandTotal = mGrandTotal - mCounts(i, mTimesliceFirst)
    Next i
    
    mTimesliceCurrent = mTimesliceFirst
    mTimesliceFirst = (mTimesliceFirst + 1) Mod mTimesliceMax
    mTimesliceCount = mTimesliceMax
    
  Else
    mTimesliceCurrent = (mTimesliceCurrent + 1) Mod mTimesliceMax
  End If
  
  mTimes(mTimesliceCurrent) = general.sonarIF.GetPingTime()
  InsertEchoes ' Into the current timeslice
  
  ' Update the totals and the grand total
  
  For i = 0 To mNBins - 1
    mTotals(i) = mTotals(i) + mCounts(i, mTimesliceCurrent)
    mGrandTotal = mGrandTotal + mCounts(i, mTimesliceCurrent)
  Next i
  
  '  Repaint the plot
  
  PlotPaint

End Sub

Public Sub PlotLayout(Optional ByVal rangeMin As Variant, _
                      Optional ByVal rangeMax As Variant, _
                      Optional ByVal nTimeslices As Variant)
                      
  If Not IsMissing(rangeMin) Then mRangeMin = rangeMin
  If Not IsMissing(rangeMax) Then mRangeMax = rangeMax
  If Not IsMissing(nTimeslices) Then
    If nTimeslices <> mTimesliceMax Then
      resizeArrays nTimeslices:=nTimeslices
    End If
  End If

  ' Compute the averaging constant, using timeFactor as the target halflife
  ' of the averager.
  
  mBarPaneX0 = 2
  mBarPaneX1 = mPicture.ScaleWidth - _
    (mPercentTick + mPercentLabelGap + mPicture.textWidth("80") + 2)
  
  TopAreaLayout
  
  Dim textWidth As Long
  Dim oldfont As Long
  
  oldfont = SelectObject(mPicture.hDC, mFont)
  textWidth = IIf(mPlotType = dptClass, Sqr(mPicture.textWidth("WWWWWWWWW") ^ 2 + mPicture.TextHeight("y^") ^ 2), _
                                      Sqr(mPicture.textWidth("-88.8") ^ 2 + mPicture.TextHeight("y^") ^ 2))
  SelectObject mPicture.hDC, oldfont
  textWidth = maxl(textWidth, mPicture.ScaleHeight * 0.15)
  
  mBarPaneY1 = mPicture.ScaleHeight - (0.5 * textWidth + 4)
  
  mBarWidth = (mBarPaneX1 - mBarPaneX0) * 2 / 3 / mNBins
  mBarSeparation = mBarWidth / 2
  
  CategoryAxisLayout
  
  PlotPaint
  
End Sub
Private Sub PlotPaint()

  mPicture.Line (mBarPaneX0, mBarPaneY0)-(mBarPaneX1, mBarPaneY1), _
                mPicture.backcolor, BF
                
  mPicture.Line (mBarPaneX0, mBarPaneY0)-(mBarPaneX1, mBarPaneY1), _
                mAxisColor, B

  If mShowPercentAxis Then PercentAxisPaint
  If mShowCategoryAxis Then CategoryAxisPaint
  If mShowTopArea Then TopAreaPaint
  
  Dim i As Long
  Dim X As Long
  Dim Y As Single
  
  X = mBarPaneX0 + mBarSeparation / 2
  For i = 0 To mNBins - 1
    
    If mGrandTotal = 0 Then
      Y = 0
    Else
      Y = mTotals(i) / mGrandTotal
    End If
    
    Y = Y * (mBarPaneY1 - mBarPaneY0)
    mPicture.Line (X, mBarPaneY1)-Step(mBarWidth, -Y), mColor(i), BF
    X = X + mBarSeparation + mBarWidth
  
  Next i
  
  If mHaveFocus Then mPicture_GotFocus
  
End Sub
Public Sub PlotSetup(ByVal prefix As String, _
                     picture As PictureBox, _
                     plotType As DistributionPlotType, _
                     rangeMin As Single, _
                     rangeMax As Single, _
                     ByVal nTimeslices As Integer, _
                     Optional ByVal tsNBins As Integer = 7, _
                     Optional ByVal TSMin As Single = -40, _
                     Optional ByVal TSMax As Single = -20, _
                     Optional ByVal colormap As Variant)
                     
  mPrefix = prefix
  Set mPicture = picture
  mPicture.ScaleMode = vbPixels
  mPicture.AutoRedraw = True
  mAxisColor = IIf(ColorIsDark(mPicture.backcolor), vbWhite, vbBlack)
  mPicture.forecolor = mAxisColor
  mPlotType = plotType
  mRangeMax = rangeMax
  mRangeMin = rangeMin
  mTimesliceMax = nTimeslices
  
  If plotType = dptClass Then
  
    'Set mClassifier = general.classifier ' AK Oct 16 2001
    Set mClassifier = general.sonarIF.GetClassifier()
        
    If Not mClassifier Is Nothing Then
    
      resizeArrays mClassifier.GetNClasses() - mClassifier.GetNImplicitClasses() + 1 ' for unknown
    
    End If
  
  Else
  
    resizeArrays tsNBins
    mTSMin = TSMin
    mTSMax = TSMax
  
  End If
  
  '  Get a colormap
    
    If Not IsMissing(colormap) Then
      Set mColormap = colormap
    Else
    
      ' None was provided, so hunt one up.
    
      Set mColormap = New ColorMapClass
      Dim mapName As String
      If plotType = dptClass Then
        If general.sonarIF.GetClassifier() Is Nothing Then
          mapName = "_StandardClass"
        Else
          Set mClassifier = general.sonarIF.GetClassifier()
          mapName = mClassifier.GetColorMapName()
          If mapName = "" Then mapName = "_StandardClass"
        End If
        On Error GoTo mapReadFailed
        mColormap.ReadFromDB mapName
mapReadFailed:
        On Error GoTo 0
      Else
        mapName = general.propertyList.GetProperty(prefix & ":ColorMapName", "_StandardEnergy")
        If mapName <> "" Then
          On Error Resume Next
          mColormap.ReadFromDB mapName
          On Error GoTo 0
        End If
      End If
    End If
  
  
  Me.Clear
  
  general.sonarIF.addPingListener Me, sonarDataEchoes
  
  PlotLayout
                      
End Sub


Private Sub resizeArrays(Optional ByVal NBins As Variant, _
                         Optional ByVal nTimeslices As Variant)

  If Not IsMissing(NBins) Then mNBins = NBins
  If Not IsMissing(nTimeslices) Then mTimesliceMax = nTimeslices
  
  ReDim mCounts(0 To mNBins - 1, 0 To mTimesliceMax - 1) As Long
  ReDim mTotals(0 To mNBins - 1) As Long
  ReDim mColor(0 To mNBins - 1) As Long
  ReDim mCategoryLabels(0 To mNBins - 1) As String
  ReDim mTimes(0 To mTimesliceMax - 1) As Date
  
  mGrandTotal = 0
  
  mTimesliceCount = 0
  mTimesliceCurrent = 0
  mTimesliceFirst = 1

End Sub
Public Sub TeardownPlot()

  general.sonarIF.removePingListener Me
  Set mPicture = Nothing

End Sub
Private Sub TopAreaLayout()

  ' Allocate room for 2 lines of text with 2 pixels before, after and between.

  mBarPaneY0 = 2 * mPicture.TextHeight("y^") + 6

End Sub
Private Sub TopAreaPaint()

  '  Erase the top area

  mPicture.Line (mBarPaneX0, 0)-(mPicture.ScaleWidth, mBarPaneY0 - 1), mPicture.backcolor, BF
  
  Dim i As Integer
  Dim label As String
  Dim X As Long
  Dim Y As Long
  X = mBarPaneX0 + mBarSeparation / 2 + mBarWidth / 2 + 1
  Y = mBarPaneY0 - mPicture.TextHeight("y^") - 2
  For i = 0 To mNBins - 1
    label = Format(mTotals(i), "###0")
    mPicture.CurrentX = X - mPicture.textWidth(label) / 2
    mPicture.CurrentY = Y
    mPicture.Print label
    X = X + mBarSeparation + mBarWidth
  Next i
  
  mPicture.CurrentX = mBarPaneX0 + 2
  mPicture.CurrentY = 2
  Dim title As String
  title = "total=" & Format(mGrandTotal, "####0")
  mPicture.Print title
  Dim interval As String
  interval = "Interval=" & _
    Format(mTimes(mTimesliceFirst) - mTimes(mTimesliceCurrent), "N:Ss")
  mPicture.CurrentX = mBarPaneX1 - mPicture.textWidth(interval)
  mPicture.CurrentY = 2
  mPicture.Print interval

End Sub

Private Sub mPicture_GotFocus()

  mPicture.DrawWidth = 2
  mPicture.Line (1, 1)-Step(mPicture.ScaleWidth - 1, mPicture.ScaleHeight - 1), _
                mFocusColor, B
  mPicture.DrawWidth = 1
  mHaveFocus = True

End Sub

Private Sub mPicture_KeyDown(KeyCode As Integer, Shift As Integer)

  Dim altbutton As Boolean
  Dim controlbutton As Boolean
  Dim keyHandled As Boolean
  Dim shiftbutton As Boolean

  shiftbutton = (Shift And vbShiftMask) <> 0
  controlbutton = (Shift And vbCtrlMask) <> 0
  altbutton = (Shift And vbAltMask) <> 0
  
  keyHandled = False
  
  Select Case KeyCode
  
  
    Case 93 ' Menu key
      RaiseEvent ContextMenuRequest(mPicture.width / 2, mPicture.height / 2)
      keyHandled = True
    
    Case vbKeyF1
      If controlbutton Then
        Dim magicKeys As MagicKeyDisplayClass
        Set magicKeys = New MagicKeyDisplayClass
        
        With magicKeys
          '.addKey vbKeyP, "cs", "Ping once"
          .display
        End With
        Set magicKeys = Nothing
      End If
      
  
  End Select

  If Not keyHandled Then RaiseEvent KeyDown(KeyCode, Shift)

End Sub

Private Sub mPicture_LostFocus()

  mPicture.DrawWidth = 2
  mPicture.Line (1, 1)-(mPicture.ScaleWidth - 1, mPicture.ScaleHeight - 1), _
                mPicture.backcolor, B
  mPicture.DrawWidth = 1
  mHaveFocus = False

End Sub

Private Sub mPicture_MouseDown(Button As Integer, Shift As Integer, X As Single, Y As Single)

  MouseController MouseDown, Button, Shift, X, Y

End Sub

Private Sub mPicture_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)

  MouseController MouseMove, Button, Shift, X, Y

End Sub
Private Sub mPicture_MouseUp(Button As Integer, Shift As Integer, X As Single, Y As Single)

  MouseController MouseUp, Button, Shift, X, Y

End Sub

Private Sub Class_Initialize()


  mFont = CreateFont(14, 0, -300, 0, FW_NORMAL, False, _
                     False, False, ANSI_CHARSET, OUT_DEFAULT_PRECIS, _
                     CLIP_CHARACTER_PRECIS, PROOF_QUALITY, _
                     VARIABLE_PITCH Or FF_ROMAN Or 4, "Garamond")
                     
  mPercentTick = (0.05 * 1440) / Screen.TwipsPerPixelX
  mPercentLabelGap = mPercentTick / 3
  
  mShowPercentAxis = True
  mShowCategoryAxis = True
  mShowTopArea = True
  mFocusColor = vbYellow
  mHaveFocus = False
  
  Set mMenu = New Scripting.Dictionary
  mMenu.CompareMode = TextCompare
  
  AddMenuItem "&Options", dpaOptions
  AddMenuItem "-", dpaSpace1
  AddMenuItem "&ChangeType", dpaChangeType

  
End Sub
